CREATE TABLE Type (
  id NUMBER PRIMARY KEY,
  name VARCHAR2(4000),
  abstract NUMBER(1) NOT NULL,
  CONSTRAINT ck_abstract_bool CHECK (abstract in (0,1)),
  trans NUMBER(1) NOT NULL,
  CONSTRAINT ck_trans_bool CHECK (trans in (0,1))
);

CREATE TABLE Association(
  id NUMBER PRIMARY KEY,
  name VARCHAR2(4000),
  owner NUMBER NOT NULL,
  CONSTRAINT fk_owner FOREIGN KEY (owner) REFERENCES TYPE(id),
  target NUMBER NOT NULL,
  CONSTRAINT fk_target FOREIGN KEY (target) REFERENCES TYPE(id),
  uniq NUMBER(1) NOT NULL,
  CONSTRAINT ck_uniq_bool CHECK (uniq in (0,1)),
  essential NUMBER(1) NOT NULL,
  CONSTRAINT ck_essential_bool CHECK (essential in (0,1))
);

CREATE TABLE MapAssociation(
  id NUMBER PRIMARY KEY,
  CONSTRAINT fk_asso_id FOREIGN KEY (id) REFERENCES Association(id),
  map_key_type NUMBER NOT NULL, 
  CONSTRAINT fk_map_key_type FOREIGN KEY (map_key_type) REFERENCES TYPE(id)
);


CREATE SEQUENCE Specialization_Seq;

CREATE TABLE Specialization (
  id NUMBER PRIMARY KEY,
  ancestor NUMBER NOT NULL,
  descendant NUMBER NOT NULL,
  CONSTRAINT fk_ancestor FOREIGN KEY (ancestor) REFERENCES TYPE(id),
  CONSTRAINT fk_descendant FOREIGN KEY (descendant) REFERENCES TYPE(id)
);


CREATE SEQUENCE InstanceItem_Seq;

CREATE TABLE Object (
  id NUMBER PRIMARY KEY,
  instance_of NUMBER NOT NULL,
  CONSTRAINT fk_io FOREIGN KEY (instance_of) REFERENCES TYPE(id)
);

CREATE TABLE Long_transaction(
  id NUMBER PRIMARY KEY,
  is_adhoc NUMBER(1) NOT NULL,
  published Timestamp,
  CONSTRAINT ck_is_adhoc_bool CHECK (is_adhoc in (0,1))
);

CREATE SEQUENCE short_transaction_seq;

CREATE TABLE short_transaction (
  id NUMBER PRIMARY KEY,
  container NUMBER NOT NULL,
  CONSTRAINT fk_container FOREIGN KEY (container) REFERENCES long_transaction(id),
  next NUMBER,
  CONSTRAINT fk_next FOREIGN KEY (next) REFERENCES short_transaction(id)
);

CREATE TABLE Integer_Value (
  id NUMBER PRIMARY KEY,
  value NUMBER NOT NULL
  );

CREATE unique INDEX idx_integer_val ON integer_value(value);

CREATE TABLE string_value (
  id NUMBER PRIMARY KEY,
  value varchar(4000) NOT NULL
);

CREATE unique INDEX idx_string_value ON string_value(value);

CREATE TABLE user_object (
  id NUMBER PRIMARY KEY,
  created NUMBER  NOT NULL,
  CONSTRAINT fk_created FOREIGN KEY (created) REFERENCES short_transaction(id)
);

CREATE TABLE Link (
  id NUMBER PRIMARY KEY,
  owner NUMBER NOT NULL,
  CONSTRAINT fk_owner_lnk FOREIGN KEY (owner) REFERENCES user_object(id),
  target NUMBER NOT NULL,
  CONSTRAINT fk_target_lnk FOREIGN KEY (target) REFERENCES object(id),
  instance_of NUMBER NOT NULL,
  CONSTRAINT fk_instance_of_lnk FOREIGN KEY (instance_of) REFERENCES Association(id),
  created NUMBER NOT NULL,
  CONSTRAINT fk_created_lnk FOREIGN KEY (created) REFERENCES short_transaction(id)
);

CREATE INDEX idx_lnk_owner ON Link(owner);
CREATE INDEX idx_lnk_target ON Link(target);

CREATE TABLE MapLink (
  id NUMBER PRIMARY KEY,
  CONSTRAINT fk_link_id FOREIGN KEY (id) REFERENCES Link(id),
  map_key NUMBER NOT NULL,
  CONSTRAINT fk_map_key FOREIGN KEY (map_key) REFERENCES Object(id)
);

CREATE INDEX idx_mplnk_map_key ON MapLink(map_key);

CREATE SEQUENCE Accessed_seq;

CREATE TABLE Accessed (
	id NUMBER PRIMARY KEY,
	v NUMBER NOT NULL,
	t NUMBER NOT NULL,
	CONSTRAINT fk_t FOREIGN KEY (t) REFERENCES short_transaction(id),
	type CHAR(1) NOT NULL,
  CONSTRAINT ck_type CHECK (type IN ('R','M','D'))
);

CREATE INDEX idx_accessed_v ON Accessed(v);
CREATE INDEX idx_accessed_t ON Accessed(t);



CREATE TABLE accounts(
  id NUMBER PRIMARY KEY,
  mandant VARCHAR2(30),
  username VARCHAR2(30),
  passwd VARCHAR2(100)
);
  
CREATE TABLE roles(
  id NUMBER PRIMARY KEY,
  name VARCHAR2(4000)
);
  
CREATE TABLE account_roles(
  id NUMBER PRIMARY KEY,
  account_id NUMBER,
  role_id NUMBER,
  CONSTRAINT fk_account FOREIGN KEY (account_id) REFERENCES accounts(id),
  CONSTRAINT fk_role FOREIGN KEY (role_id) REFERENCES roles(id)
);


CREATE SEQUENCE accounts_seq;
CREATE SEQUENCE roles_seq;
CREATE SEQUENCE account_roles_seq;

CREATE OR REPLACE TYPE array_int IS TABLE OF NUMBER









