package de.fhdw.wtf.persistence.meta;

/**
 * A Class which represents any WTF-Class.
 * 
 */
public abstract class Type extends ModelItem {
	
	/**
	 * A field which represents the information if the represented type is abstract.
	 */
	private final boolean abs;
	
	/**
	 * A field which represents the information if the type is also a transaction.
	 */
	private final boolean trans;
	
	/**
	 * Getter for the isAbstract information.
	 * 
	 * @return Provides true if the type is abstract.
	 */
	public boolean isAbs() {
		return this.abs;
	}
	
	/**
	 * Getter for IsTransaction.
	 * 
	 * @return Provides true if the instances to this type are Transactions.
	 */
	public boolean isTrans() {
		return this.trans;
	}
	
	/**
	 * The constructor for a new Type.
	 * 
	 * @param id
	 *            The Id in the Database.
	 * @param name
	 *            The name of this type.
	 * @param abs
	 *            is the Type abstract ?
	 * @param trans
	 *            ist the Type a transaction ?
	 */
	protected Type(final long id, final String name, final boolean abs, final boolean trans) {
		super(id, name);
		this.abs = abs;
		this.trans = trans;
	}
	
	@Override
	public String toString() {
		return Long.toString(this.getId());
	}
	
	public abstract void accept(TypeVisitor typeVisitor);
	
	public abstract <X> X accept(TypeVisitorReturn<X> typeVisitor);
	
	/**
	 * Calls the appropriate handle-method on the given TypeVisitorException.
	 * 
	 * @param typeVisitor
	 *            the given TypeVisitorException.
	 * @throws Exc
	 *             can be thrown when also thrown by called handle-method.
	 */
	public abstract <Exc extends Exception> void accept(TypeVisitorException<Exc> typeVisitor) throws Exc;
	
	public abstract <X, Y extends Exception> X accept(TypeVisitorReturnException<X, Y> typeVisitorReturnException)
			throws Y;
	
}
