/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.persistence.facade;

import de.fhdw.wtf.persistence.exception.IDContractViolationException;
import de.fhdw.wtf.persistence.exception.IDNotFoundForNameException;
import de.fhdw.wtf.persistence.exception.IDPersistenceFilesNotFound;
import de.fhdw.wtf.persistence.exception.OtherSQLException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.facade.OracleDatabaseManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.OracleCallableStatement;

public final class IDManager {
    private static final long MAX_BASE_TYPES = 2L;
    private static final long MAX_CONTRACT_ASSOCIATION_ID = 0L;
    public static final String TYPE_IDS_FILENAME = "types.properties";
    public static final String ASSOCIATION_IDS_FILENAME = "associations.properties";
    private static IDManager instance = null;
    private final Properties typeNameIdRelation = new Properties();
    private final Properties associationNameIdRelation = new Properties();
    private long currentlyUsedTypeMaxId;
    private long currentlyUsedAssociationMaxId = IDManager.getMaxAssociationContractID();

    private IDManager() {
        this.currentlyUsedTypeMaxId = IDManager.getMaxBaseTypeID();
    }

    private void recalibrateMaxTypeID() {
        for (String currentKey : this.typeNameIdRelation.stringPropertyNames()) {
            Long currentId = Long.parseLong(this.typeNameIdRelation.getProperty(currentKey));
            if (this.currentlyUsedTypeMaxId >= currentId) continue;
            this.currentlyUsedTypeMaxId = currentId;
        }
    }

    private void recalibrateMaxAssociationID() {
        for (String currentKey : this.associationNameIdRelation.stringPropertyNames()) {
            Long currentId = Long.parseLong(this.associationNameIdRelation.getProperty(currentKey));
            if (this.currentlyUsedAssociationMaxId >= currentId) continue;
            this.currentlyUsedAssociationMaxId = currentId;
        }
    }

    public void initializeRelationsFromFile(String typeIdsFilename, String associationIdsFilename) throws FileNotFoundException, IOException {
        block25: {
            File fileType = new File(typeIdsFilename);
            File fileAssociation = new File(associationIdsFilename);
            if (fileType.exists() && !fileType.isDirectory() && fileAssociation.exists() && !fileAssociation.isDirectory()) {
                try (FileInputStream fileTypeInputStream = new FileInputStream(fileType);
                     FileInputStream fileAssociationInputStream = new FileInputStream(fileAssociation);){
                    this.typeNameIdRelation.load(fileTypeInputStream);
                    this.associationNameIdRelation.load(fileAssociationInputStream);
                    break block25;
                }
            }
            throw new IDPersistenceFilesNotFound();
        }
        this.typeNameIdRelation.setProperty("String", Long.toString(1L));
        this.typeNameIdRelation.setProperty("Integer", Long.toString(2L));
        this.recalibrateMaxTypeID();
        this.recalibrateMaxAssociationID();
    }

    public void initializeRelationsFromDatabase() throws PersistenceException, SQLException {
        Throwable throwable;
        ResultSet result;
        Throwable throwable2;
        CallableStatement call;
        OracleDatabaseManager database = OracleDatabaseManager.getInstance();
        try {
            database.getConnection();
        }
        catch (PersistenceException e) {
            database.connect();
        }
        try {
            call = database.getConnection().prepareCall("begin ?:= " + database.getSchemaName() + ".classfacade.getAllTypes; end;");
            throwable2 = null;
            try {
                call.registerOutParameter(1, -10);
                call.execute();
                result = ((OracleCallableStatement)call).getCursor(1);
                throwable = null;
                try {
                    while (result.next()) {
                        this.typeNameIdRelation.setProperty(result.getString(2), Long.toString(result.getLong(1)));
                    }
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            catch (Throwable x2) {
                throwable2 = x2;
                throw x2;
            }
            finally {
                if (call != null) {
                    if (throwable2 != null) {
                        try {
                            call.close();
                        }
                        catch (Throwable x2) {
                            throwable2.addSuppressed(x2);
                        }
                    } else {
                        call.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        try {
            call = database.getConnection().prepareCall("begin ?:= " + database.getSchemaName() + ".classfacade.getAllUnidirAssociations; end;");
            throwable2 = null;
            try {
                call.registerOutParameter(1, -10);
                call.execute();
                result = ((OracleCallableStatement)call).getCursor(1);
                throwable = null;
                try {
                    while (result.next()) {
                        this.associationNameIdRelation.setProperty(result.getString(2), Long.toString(result.getLong(1)));
                    }
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            catch (Throwable x2) {
                throwable2 = x2;
                throw x2;
            }
            finally {
                if (call != null) {
                    if (throwable2 != null) {
                        try {
                            call.close();
                        }
                        catch (Throwable x2) {
                            throwable2.addSuppressed(x2);
                        }
                    } else {
                        call.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        try {
            call = database.getConnection().prepareCall("begin ?:= " + database.getSchemaName() + ".classfacade.getAllMapAssociations; end;");
            throwable2 = null;
            try {
                call.registerOutParameter(1, -10);
                call.execute();
                result = ((OracleCallableStatement)call).getCursor(1);
                throwable = null;
                try {
                    while (result.next()) {
                        this.associationNameIdRelation.setProperty(result.getString(2), Long.toString(result.getLong(1)));
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
            finally {
                if (call != null) {
                    if (throwable2 != null) {
                        try {
                            call.close();
                        }
                        catch (Throwable x2) {
                            throwable2.addSuppressed(x2);
                        }
                    } else {
                        call.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        this.typeNameIdRelation.setProperty("String", Long.toString(1L));
        this.typeNameIdRelation.setProperty("Integer", Long.toString(2L));
        this.recalibrateMaxTypeID();
        this.recalibrateMaxAssociationID();
    }

    public static synchronized IDManager instance() {
        if (instance == null) {
            instance = new IDManager();
        }
        return instance;
    }

    public void clearInformation() {
        this.typeNameIdRelation.clear();
        this.associationNameIdRelation.clear();
        this.currentlyUsedAssociationMaxId = IDManager.getMaxAssociationContractID();
        this.currentlyUsedTypeMaxId = IDManager.getMaxBaseTypeID();
    }

    public static long getMaxBaseTypeID() {
        return 2L;
    }

    public static long getMaxAssociationContractID() {
        return 0L;
    }

    public void persistIDRelationsToFile(String typeIdsFilename, String associationIdsFilename) throws IOException {
        try (FileOutputStream file = new FileOutputStream(typeIdsFilename);){
            this.typeNameIdRelation.store(file, "");
            file.flush();
        }
        file = new FileOutputStream(associationIdsFilename);
        var4_4 = null;
        try {
            this.associationNameIdRelation.store(file, "");
            file.flush();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (file != null) {
                if (var4_4 != null) {
                    try {
                        file.close();
                    }
                    catch (Throwable x2) {
                        var4_4.addSuppressed(x2);
                    }
                } else {
                    file.close();
                }
            }
        }
    }

    public synchronized long pullNextUnusedTypeID(String typeName) {
        if (typeName.equals("String") || typeName.equals("Integer")) {
            throw new IDContractViolationException();
        }
        ++this.currentlyUsedTypeMaxId;
        this.typeNameIdRelation.setProperty(typeName, Long.toString(this.currentlyUsedTypeMaxId));
        return this.currentlyUsedTypeMaxId;
    }

    public synchronized long pullNextUnusedAssociationID(String associationName) {
        ++this.currentlyUsedAssociationMaxId;
        this.associationNameIdRelation.setProperty(associationName, Long.toString(this.currentlyUsedAssociationMaxId));
        return this.currentlyUsedAssociationMaxId;
    }

    public long findIdForType(String typeName) throws IDNotFoundForNameException {
        if (!this.typeNameIdRelation.containsKey(typeName)) {
            throw new IDNotFoundForNameException();
        }
        return Long.parseLong(this.typeNameIdRelation.getProperty(typeName));
    }

    public long findIdForAssociation(String associationName) throws IDNotFoundForNameException {
        if (!this.associationNameIdRelation.containsKey(associationName)) {
            throw new IDNotFoundForNameException();
        }
        return Long.parseLong(this.associationNameIdRelation.getProperty(associationName));
    }
}

