package de.fhdw.wtf.persistence.utils;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PropertiesReaderRessource implements PropertiesReader {
	
	/**
	 * Stores the internal key-value-pairs.
	 */
	private final HashMap<String, String> propValues = new HashMap<>();
	
	/**
	 * Deletes the internal instance. You should initialize it again with the method "getInstance(String propFile)".
	 */
	public void reset() {
		this.propValues.clear();
	}
	
	@Override
	public void initialize(final String propFile) throws MissingResourceException {
		this.reset();
		final ResourceBundle rb = ResourceBundle.getBundle(propFile);
		final Enumeration<String> keys = rb.getKeys();
		while (keys.hasMoreElements()) {
			final String key = keys.nextElement();
			final String value = rb.getString(key);
			this.propValues.put(key, value);
		}
	}
	
	@Override
	public String getProperty(final String key) {
		if (!this.propValues.containsKey(key)) {
			return "";
		}
		return this.propValues.get(key);
	}
}
