package de.fhdw.wtf.persistence.exception;

/**
 * A class to represent an exception which occurs when a the database is accessed with a Transaction, which is either a
 * closed transaction or even not a Transaction at all.
 * 
 */
public class NoValidTransactionException extends PersistenceException {
	/**
	 * the message of the exception.
	 */
	private static final String NO_VALID_TRANSACTION_MESSAGE =
			"The given Transaction was either a closed transaction or even not a Transaction at all";
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * Konstruktor der die entsprechende Fehlermeldung zur�ckgibt.
	 */
	public NoValidTransactionException() {
		super(NO_VALID_TRANSACTION_MESSAGE, null);
	}
	
	@Override
	public void printStackTrace() {
		System.err.println(this.getMessage() + this.fillInStackTrace());
	}
}
