package de.fhdw.wtf.persistence.utils;

import java.sql.CallableStatement;
import java.sql.SQLException;

import de.fhdw.wtf.persistence.meta.Object;

/**
 * Abstract wrapper for Database Querys.
 */
public interface DBConnectionObjectHandler {
	/**
	 * 
	 * @return a character who is representing the type of the object.
	 */
	String getObjectTypeString();
	
	/**
	 * adds the wrapped object to the <call> statement at position <parameterIndex>.
	 * 
	 * @param call
	 *            current DB call statement
	 * @param parameterIndex
	 *            the parameter index of the statement
	 * @throws SQLException
	 */
	void handleCall(CallableStatement call, int parameterIndex) throws SQLException;
	
	/**
	 * gets the wrapped object.
	 * 
	 * @return the wrapped object as a Object
	 */
	Object getObject();
}
