package de.fhdw.wtf.persistence.exception;

import java.sql.SQLException;

import de.fhdw.wtf.persistence.facade.OracleDatabaseManager;

/**
 * A class to represent Exceptions, which occur when the connection towards the database could not be established.
 * 
 */
public class NotConnectableException extends PersistenceException {
	
	/**
	 * a part of the message of the exception.
	 */
	private static final String CONNECTION_FAILED_INFIX_PASSWORD = " password:";
	/**
	 * a part of the message of the exception.
	 */
	private static final String CONNECTION_FAILED_USERNAME = " username:";
	/**
	 * a part of the message of the exception.
	 */
	private static final String CONNECTION_FAILED_INFIX_PORT = " port:";
	/**
	 * a part of the message of the exception.
	 */
	private static final String CONNECTION_FAILED_INFIX_ORACLE_SID = " SID:";
	/**
	 * a part of the message of the exception.
	 */
	private static final String CONNECTION_FAILED_INFIX_SHEMA = " schema-name:";
	/**
	 * a part of the message of the exception.
	 */
	private static final String CONNECTION_FAILED_PREFIX_ORACLE =
			"Could not connect to Oracle Database with the Parameters: hostname:";
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * Constructor for a NotConnectableException for Oracle Databases.
	 * 
	 * @param db
	 *            Fehler der Datenbank.
	 * @param nested
	 *            Verschachtelte SQLException.
	 */
	public NotConnectableException(final OracleDatabaseManager db, final SQLException nested) {
		super(CONNECTION_FAILED_PREFIX_ORACLE + db.getHostname() + CONNECTION_FAILED_INFIX_SHEMA + db.getSchemaName()
				+ CONNECTION_FAILED_INFIX_ORACLE_SID + db.getOracleSID() + CONNECTION_FAILED_INFIX_PORT + db.getPort()
				+ CONNECTION_FAILED_USERNAME + db.getUserName() + CONNECTION_FAILED_INFIX_PASSWORD
				+ db.getUserPassword(), nested);
	}
	
}
