CREATE OR REPLACE PACKAGE Accountfacade IS

TYPE userRecord IS RECORD(
    id NUMBER,
    mandant VARCHAR2(30),
    name VARCHAR2(30));
TYPE userRecordCursor IS REF CURSOR RETURN userRecord;

TYPE roleRecord IS RECORD(
    id NUMBER,
    name VARCHAR2(4000));
TYPE roleRecordCursor IS REF CURSOR RETURN roleRecord;

FUNCTION createUser(mandant VARCHAR2,username VARCHAR2,passwd VARCHAR2) RETURN NUMBER;
FUNCTION createRole(name VARCHAR2) RETURN NUMBER; 
PROCEDURE addRoleToUser(user_id NUMBER, role_id NUMBER);
FUNCTION authorize(m VARCHAR2,u VARCHAR2, p VARCHAR2) RETURN NUMBER;
FUNCTION getRoles(m VARCHAR2, u VARCHAR2) RETURN roleRecordCursor;
FUNCTION getAllUsersForMandant(m VARCHAR2) RETURN userRecordCursor;
FUNCTION getUser(m VARCHAR2, u VARCHAR2) RETURN userRecordCursor;
FUNCTION getRoleId(role_name VARCHAR2) RETURN NUMBER;
FUNCTION getRoles RETURN roleRecordCursor;

END Accountfacade;

