/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.persistence.facade;

import de.fhdw.wtf.persistence.exception.BaseTypeNotFoundException;
import de.fhdw.wtf.persistence.exception.InvalidLinkException;
import de.fhdw.wtf.persistence.exception.NotInstantiatableException;
import de.fhdw.wtf.persistence.exception.NotValidInputException;
import de.fhdw.wtf.persistence.exception.ObjectNotFoundException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.facade.ClassFacade;
import de.fhdw.wtf.persistence.facade.ObjectFacade;
import de.fhdw.wtf.persistence.facade.TypeManager;
import de.fhdw.wtf.persistence.facade.TypeManagerImplementation;
import de.fhdw.wtf.persistence.meta.AdhocTransaction;
import de.fhdw.wtf.persistence.meta.Association;
import de.fhdw.wtf.persistence.meta.IntegerValue;
import de.fhdw.wtf.persistence.meta.Link;
import de.fhdw.wtf.persistence.meta.MapAssociation;
import de.fhdw.wtf.persistence.meta.MapLink;
import de.fhdw.wtf.persistence.meta.Object;
import de.fhdw.wtf.persistence.meta.StringValue;
import de.fhdw.wtf.persistence.meta.Transaction;
import de.fhdw.wtf.persistence.meta.UnidirectionalAssociation;
import de.fhdw.wtf.persistence.meta.UnidirectionalLink;
import de.fhdw.wtf.persistence.meta.UserObject;
import de.fhdw.wtf.persistence.meta.UserType;
import de.fhdw.wtf.persistence.utils.Tuple;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public class NoDatabaseObjectFacadeImplementation
implements ObjectFacade {
    private static final long INITIAL_NEXT_ID = 1L;
    private final ClassFacade classFacade;
    private long nextId;
    private final Map<Long, UserObject> idToUserObject;
    private final Map<UserType, Collection<UserObject>> userTypeMappingToUserObjects;
    private final Map<Long, BigInteger> integerValues;
    private final Map<BigInteger, Long> inverseIntegerValues;
    private final Map<Long, String> stringValues;
    private final Map<String, Long> inverseStringValues;
    private final Map<Object, Collection<Tuple<UnidirectionalLink, UserObject>>> targetMappingToUnidirectionalLinksWithOwners;
    private final Map<UserObject, Collection<Tuple<UnidirectionalLink, Object>>> ownerMappingToUnidirectionalLinksWithTargets;
    private final HashMap<UserObject, Collection<MapLink>> ownerMappingToMapLinks;
    private final HashMap<Object, Collection<MapLink>> targetMappingToMapLinks;

    public NoDatabaseObjectFacadeImplementation(ClassFacade classFacade) {
        IntegerValue.setObjectFacade(this);
        StringValue.setObjectFacade(this);
        this.classFacade = classFacade;
        this.nextId = 1L;
        this.userTypeMappingToUserObjects = new HashMap<UserType, Collection<UserObject>>();
        this.integerValues = new HashMap<Long, BigInteger>();
        this.stringValues = new HashMap<Long, String>();
        this.inverseIntegerValues = new HashMap<BigInteger, Long>();
        this.inverseStringValues = new HashMap<String, Long>();
        this.idToUserObject = new HashMap<Long, UserObject>();
        this.targetMappingToUnidirectionalLinksWithOwners = new HashMap<Object, Collection<Tuple<UnidirectionalLink, UserObject>>>();
        this.ownerMappingToUnidirectionalLinksWithTargets = new HashMap<UserObject, Collection<Tuple<UnidirectionalLink, Object>>>();
        this.ownerMappingToMapLinks = new HashMap();
        this.targetMappingToMapLinks = new HashMap();
    }

    @Override
    public void clear() throws PersistenceException {
        this.nextId = 1L;
        this.userTypeMappingToUserObjects.clear();
        this.integerValues.clear();
        this.stringValues.clear();
        this.inverseIntegerValues.clear();
        this.inverseStringValues.clear();
        this.idToUserObject.clear();
        this.ownerMappingToUnidirectionalLinksWithTargets.clear();
        this.targetMappingToUnidirectionalLinksWithOwners.clear();
        this.ownerMappingToMapLinks.clear();
        this.targetMappingToMapLinks.clear();
    }

    @Override
    public Collection<UserObject> find(Association association, String string, Date date) throws PersistenceException {
        HashSet<UserObject> result = new HashSet<UserObject>();
        String searchFor = string.trim();
        String searchForWithoutPercent = string.trim().replace("%", "");
        for (Object ob : this.targetMappingToUnidirectionalLinksWithOwners.keySet()) {
            if (!(ob instanceof StringValue)) continue;
            String val = ((StringValue)ob).getValue();
            for (Tuple<UnidirectionalLink, UserObject> tuple : this.targetMappingToUnidirectionalLinksWithOwners.get(ob)) {
                if (!tuple.getFirst().getInstanceOf().equals(association)) continue;
                if (searchFor.startsWith("%") && searchFor.endsWith("%") && searchFor.split("%").length == 2) {
                    if (!val.contains(searchForWithoutPercent)) continue;
                    result.add(tuple.getSecond());
                    continue;
                }
                if (searchFor.startsWith("%") && !searchFor.endsWith("%")) {
                    if (!val.endsWith(searchForWithoutPercent)) continue;
                    result.add(tuple.getSecond());
                    continue;
                }
                if (!searchFor.startsWith("%") && searchFor.endsWith("%")) {
                    if (!val.startsWith(searchForWithoutPercent)) continue;
                    result.add(tuple.getSecond());
                    continue;
                }
                if (searchFor.split("%").length > 0) {
                    String[] searchForElements = searchFor.split("%");
                    int index = -1;
                    for (String s : searchForElements) {
                        if (index >= val.indexOf(s)) {
                            index = -1;
                            break;
                        }
                        index = val.indexOf(s);
                    }
                    if (index <= -1) continue;
                    result.add(tuple.getSecond());
                    continue;
                }
                if (!val.equals(string)) continue;
                result.add(tuple.getSecond());
            }
        }
        return result;
    }

    @Override
    public Collection<UserObject> find(Association association, BigInteger integer, Date date) throws PersistenceException {
        LinkedList<UserObject> result = new LinkedList<UserObject>();
        for (Object ob : this.targetMappingToUnidirectionalLinksWithOwners.keySet()) {
            if (!(ob instanceof IntegerValue)) continue;
            IntegerValue obAsInteger = (IntegerValue)ob;
            for (Tuple<UnidirectionalLink, UserObject> tuple : this.targetMappingToUnidirectionalLinksWithOwners.get(ob)) {
                UnidirectionalAssociation tupleInstance = tuple.getFirst().getInstanceOf();
                if (!tupleInstance.equals(association) || !obAsInteger.getValue().equals(integer)) continue;
                result.add(tuple.getSecond());
            }
        }
        return result;
    }

    @Override
    public Collection<Tuple<UnidirectionalLink, Object>> get(UserObject owner, UnidirectionalAssociation association, Date date) throws PersistenceException {
        return this.get(owner, association);
    }

    @Override
    public Collection<Object> get(UserObject owner, MapAssociation association, String key, Date date) throws PersistenceException {
        LinkedList<Object> result = new LinkedList<Object>();
        if (!this.ownerMappingToMapLinks.containsKey(owner)) {
            return result;
        }
        for (MapLink currentMapLink : this.ownerMappingToMapLinks.get(owner)) {
            if (!currentMapLink.getInstanceOf().equals(association) || !(currentMapLink.getKey() instanceof StringValue) || !((StringValue)currentMapLink.getKey()).getValue().equals(key)) continue;
            result.add(currentMapLink.getTarget());
        }
        if (result.isEmpty()) {
            throw new ObjectNotFoundException();
        }
        return result;
    }

    @Override
    public Collection<Object> get(UserObject owner, MapAssociation association, BigInteger key, Date date) throws PersistenceException {
        LinkedList<Object> result = new LinkedList<Object>();
        if (!this.ownerMappingToMapLinks.containsKey(owner)) {
            return result;
        }
        for (MapLink currentMapLink : this.ownerMappingToMapLinks.get(owner)) {
            if (!currentMapLink.getInstanceOf().equals(association) || !(currentMapLink.getKey() instanceof IntegerValue) || !((IntegerValue)currentMapLink.getKey()).getValue().equals(key)) continue;
            result.add(currentMapLink.getTarget());
        }
        if (result.isEmpty()) {
            throw new ObjectNotFoundException();
        }
        return result;
    }

    @Override
    public Collection<Object> get(UserObject owner, MapAssociation association, UserObject key, Date date) throws PersistenceException {
        if (key == null) {
            throw new NotValidInputException("");
        }
        LinkedList<Object> result = new LinkedList<Object>();
        if (!this.ownerMappingToMapLinks.containsKey(owner)) {
            return result;
        }
        for (MapLink currentMapLink : this.ownerMappingToMapLinks.get(owner)) {
            if (!currentMapLink.getInstanceOf().equals(association) || !(currentMapLink.getKey() instanceof UserObject) || !currentMapLink.getKey().equals(key)) continue;
            result.add(currentMapLink.getTarget());
        }
        if (result.isEmpty()) {
            throw new ObjectNotFoundException();
        }
        return result;
    }

    @Override
    public Collection<Tuple<UnidirectionalLink, UserObject>> inverseGet(UserObject target, UnidirectionalAssociation association, Date date) throws PersistenceException {
        return this.inverseGet(target, association);
    }

    @Override
    public Collection<Tuple<UserObject, Object>> inverseGet(UserObject target, MapAssociation association, Date date) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Tuple<UserObject, Object>> inverseGet(String target, MapAssociation association, Date date) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Tuple<UserObject, Object>> inverseGet(BigInteger target, MapAssociation association, Date date) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<UserObject> find(Association assoc, String str, Transaction trans) throws PersistenceException {
        return this.find(assoc, str, new Date());
    }

    @Override
    public Collection<UserObject> find(Association association, BigInteger integer, Transaction transaction) throws PersistenceException {
        return this.find(association, integer, new Date());
    }

    @Override
    public Collection<Tuple<UnidirectionalLink, Object>> get(UserObject owner, UnidirectionalAssociation association, Transaction transaction) throws PersistenceException {
        return this.get(owner, association);
    }

    private Collection<Tuple<UnidirectionalLink, Object>> get(UserObject owner, UnidirectionalAssociation association) {
        LinkedList<Tuple<UnidirectionalLink, Object>> result = new LinkedList<Tuple<UnidirectionalLink, Object>>();
        if (!this.ownerMappingToUnidirectionalLinksWithTargets.containsKey(owner)) {
            return result;
        }
        for (Tuple<UnidirectionalLink, Object> currentTuple : this.ownerMappingToUnidirectionalLinksWithTargets.get(owner)) {
            if (!currentTuple.getFirst().getInstanceOf().isTheSameAs(association)) continue;
            result.add(currentTuple);
        }
        return result;
    }

    @Override
    public Collection<Tuple<MapLink, Object>> get(UserObject owner, MapAssociation association, String key, Transaction transaction) throws PersistenceException {
        HashSet<Tuple<MapLink, Object>> result = new HashSet<Tuple<MapLink, Object>>();
        if (!this.ownerMappingToMapLinks.containsKey(owner)) {
            return result;
        }
        for (MapLink currentMapLink : this.ownerMappingToMapLinks.get(owner)) {
            if (!currentMapLink.getInstanceOf().equals(association) || !((StringValue)currentMapLink.getKey()).getValue().equals(key)) continue;
            result.add(new Tuple<MapLink, Object>(currentMapLink, currentMapLink.getTarget()));
        }
        return result;
    }

    @Override
    public Collection<Tuple<MapLink, Object>> get(UserObject owner, MapAssociation association, BigInteger key, Transaction transaction) throws PersistenceException {
        HashSet<Tuple<MapLink, Object>> result = new HashSet<Tuple<MapLink, Object>>();
        if (!this.ownerMappingToMapLinks.containsKey(owner)) {
            return result;
        }
        for (MapLink currentMapLink : this.ownerMappingToMapLinks.get(owner)) {
            if (!currentMapLink.getInstanceOf().equals(association) || !((IntegerValue)currentMapLink.getKey()).getValue().equals(key)) continue;
            result.add(new Tuple<MapLink, Object>(currentMapLink, currentMapLink.getTarget()));
        }
        return result;
    }

    @Override
    public Collection<Tuple<MapLink, Object>> get(UserObject owner, MapAssociation association, UserObject key, Transaction transaction) throws PersistenceException {
        HashSet<Tuple<MapLink, Object>> result = new HashSet<Tuple<MapLink, Object>>();
        if (!this.ownerMappingToMapLinks.containsKey(owner)) {
            return result;
        }
        for (MapLink currentMapLink : this.ownerMappingToMapLinks.get(owner)) {
            if (!currentMapLink.getInstanceOf().equals(association) || !currentMapLink.getKey().equals(key)) continue;
            result.add(new Tuple<MapLink, Object>(currentMapLink, currentMapLink.getTarget()));
        }
        return result;
    }

    @Override
    public Collection<Tuple<UnidirectionalLink, UserObject>> inverseGet(UserObject target, UnidirectionalAssociation association, Transaction transaction) throws PersistenceException {
        return this.inverseGet(target, association);
    }

    private Collection<Tuple<UnidirectionalLink, UserObject>> inverseGet(UserObject target, UnidirectionalAssociation association) {
        LinkedList<Tuple<UnidirectionalLink, UserObject>> result = new LinkedList<Tuple<UnidirectionalLink, UserObject>>();
        if (!this.targetMappingToUnidirectionalLinksWithOwners.containsKey(target)) {
            return result;
        }
        for (Tuple<UnidirectionalLink, UserObject> currentTuple : this.targetMappingToUnidirectionalLinksWithOwners.get(target)) {
            if (!currentTuple.getFirst().getInstanceOf().isTheSameAs(association)) continue;
            result.add(currentTuple);
        }
        return result;
    }

    @Override
    public Collection<Tuple<UserObject, Object>> inverseGet(UserObject target, MapAssociation association, Transaction transaction) throws PersistenceException {
        LinkedList<Tuple<UserObject, Object>> result = new LinkedList<Tuple<UserObject, Object>>();
        return result;
    }

    @Override
    public Collection<Tuple<UserObject, Object>> inverseGet(String target, MapAssociation association, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Tuple<UserObject, Object>> inverseGet(BigInteger target, MapAssociation association, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public boolean isInConflict(Transaction before, Transaction after) throws PersistenceException {
        return false;
    }

    @Override
    public boolean isOpenTransaction(Transaction transaction) throws PersistenceException {
        return true;
    }

    @Override
    public UserObject create(UserType type, Transaction transaction) throws PersistenceException {
        if (type.isAbs()) {
            throw new NotInstantiatableException(new SQLException());
        }
        UserObject result = UserObject.init(this.getAndIncrementNextId(), type);
        this.idToUserObject.put(result.getId(), result);
        this.mapUserTypeToEmptyListIfNotExists(type);
        this.userTypeMappingToUserObjects.get(type).add(result);
        return result;
    }

    @Override
    public void delete(UserObject object, Transaction transaction) throws PersistenceException {
        this.idToUserObject.remove(object.getId());
        this.userTypeMappingToUserObjects.get(object.getInstanceOf()).remove(object);
        this.ownerMappingToUnidirectionalLinksWithTargets.remove(object);
        this.targetMappingToUnidirectionalLinksWithOwners.remove(object);
    }

    @Override
    public UnidirectionalLink set(UserObject owner, UnidirectionalAssociation association, UserObject target, Transaction transaction) throws PersistenceException {
        return this.set(owner, association, target);
    }

    @Override
    public UnidirectionalLink set(UserObject owner, UnidirectionalAssociation association, BigInteger target, Transaction transaction) throws PersistenceException {
        return this.set(owner, association, new IntegerValue(target));
    }

    @Override
    public UnidirectionalLink set(UserObject owner, UnidirectionalAssociation association, String target, Transaction transaction) throws PersistenceException {
        return this.set(owner, association, new StringValue(target));
    }

    private UnidirectionalLink set(UserObject owner, UnidirectionalAssociation association, Object target) throws PersistenceException {
        this.throwInvalidLinkExceptionIfWrongTypeForLink(owner, association, target);
        UnidirectionalLink result = new UnidirectionalLink(this.getAndIncrementNextId(), owner, target, association);
        Tuple<UnidirectionalLink, Object> tupleForOwner = new Tuple<UnidirectionalLink, Object>(result, target);
        if (!this.ownerMappingToUnidirectionalLinksWithTargets.containsKey(owner)) {
            this.ownerMappingToUnidirectionalLinksWithTargets.put(owner, new LinkedList());
        }
        Tuple<UnidirectionalLink, UserObject> tupleForTarget = new Tuple<UnidirectionalLink, UserObject>(result, owner);
        if (!this.targetMappingToUnidirectionalLinksWithOwners.containsKey(target)) {
            this.targetMappingToUnidirectionalLinksWithOwners.put(target, new LinkedList());
        }
        if (association.isUnique()) {
            this.ownerMappingToUnidirectionalLinksWithTargets.get(owner).clear();
            this.targetMappingToUnidirectionalLinksWithOwners.get(target).clear();
        }
        this.ownerMappingToUnidirectionalLinksWithTargets.get(owner).add(tupleForOwner);
        this.targetMappingToUnidirectionalLinksWithOwners.get(target).add(tupleForTarget);
        return result;
    }

    private void throwInvalidLinkExceptionIfWrongTypeForLink(UserObject owner, UnidirectionalAssociation association, Object target) throws PersistenceException {
        if (!this.classFacade.isSuperClassTo(association.getTarget(), target.getInstanceOf()) || !this.classFacade.isSuperClassTo(association.getOwner(), owner.getInstanceOf())) {
            throw new InvalidLinkException(new SQLException());
        }
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, UserObject target, String key, Transaction transaction) throws PersistenceException {
        return this.putInternal(owner, association, target, new StringValue(key));
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, BigInteger target, String key, Transaction transaction) throws PersistenceException {
        return this.putInternal(owner, association, new IntegerValue(target), new StringValue(key));
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, String target, String key, Transaction transaction) throws PersistenceException {
        return this.putInternal(owner, association, new StringValue(target), new StringValue(key));
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, UserObject target, BigInteger key, Transaction transaction) throws PersistenceException {
        return this.putInternal(owner, association, target, new IntegerValue(key));
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, BigInteger target, BigInteger key, Transaction transaction) throws PersistenceException {
        return this.putInternal(owner, association, new IntegerValue(target), new IntegerValue(key));
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, String target, BigInteger key, Transaction transaction) throws PersistenceException {
        return this.putInternal(owner, association, new StringValue(target), new IntegerValue(key));
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, UserObject target, UserObject key, Transaction transaction) throws PersistenceException {
        return this.putInternal(owner, association, target, key);
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, BigInteger target, UserObject key, Transaction transaction) throws PersistenceException {
        return this.putInternal(owner, association, new IntegerValue(target), key);
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, String target, UserObject key, Transaction transaction) throws PersistenceException {
        return this.putInternal(owner, association, new StringValue(target), key);
    }

    private MapLink putInternal(UserObject owner, MapAssociation association, Object target, Object key) throws PersistenceException {
        if (!this.ownerMappingToMapLinks.containsKey(owner)) {
            this.ownerMappingToMapLinks.put(owner, new LinkedList());
        }
        if (!this.targetMappingToMapLinks.containsKey(target)) {
            this.targetMappingToMapLinks.put(target, new LinkedList());
        }
        MapLink result = new MapLink(this.getAndIncrementNextId(), owner, target, key, association);
        this.ownerMappingToMapLinks.get(owner).add(result);
        this.targetMappingToMapLinks.get(target).add(result);
        return result;
    }

    @Override
    public void unset(Link link, Transaction transaction) throws PersistenceException {
    }

    @Override
    public void commit(Transaction transaction) throws PersistenceException {
    }

    @Override
    public void rollback(Transaction transaction) throws PersistenceException {
    }

    @Override
    public void savePoint(Transaction transaction) throws PersistenceException {
    }

    @Override
    public void rollbackToSavePoint(Transaction transaction) throws PersistenceException {
    }

    @Override
    public BigInteger getIntForId(long id) throws PersistenceException {
        if (!this.integerValues.containsKey(id)) {
            throw new BaseTypeNotFoundException();
        }
        return this.integerValues.get(id);
    }

    @Override
    public String getStringForId(long id) throws PersistenceException {
        if (!this.stringValues.containsKey(id)) {
            throw new BaseTypeNotFoundException();
        }
        return this.stringValues.get(id);
    }

    @Override
    public long getIdForString(String string) throws PersistenceException {
        if (!this.inverseStringValues.containsKey(string)) {
            long newId = this.getAndIncrementNextId();
            this.stringValues.put(newId, string);
            this.inverseStringValues.put(string, newId);
        }
        return this.inverseStringValues.get(string);
    }

    @Override
    public long getIdForInteger(BigInteger integer) throws PersistenceException {
        if (!this.inverseIntegerValues.containsKey(integer)) {
            long newId = this.getAndIncrementNextId();
            this.integerValues.put(newId, integer);
            this.inverseIntegerValues.put(integer, newId);
        }
        return this.inverseIntegerValues.get(integer);
    }

    @Override
    public Transaction provideAdhocTransaction() throws PersistenceException {
        return new AdhocTransaction(this.getAndIncrementNextId());
    }

    @Override
    public TypeManager getTypeManager() {
        return TypeManagerImplementation.getInstance();
    }

    @Override
    public Collection<UserObject> findAllObjects(UserType type, Transaction transaction) throws PersistenceException {
        this.mapUserTypeToEmptyListIfNotExists(type);
        return this.userTypeMappingToUserObjects.get(type);
    }

    @Override
    public UserObject checkUserObjectOut(long id, Transaction transaction) throws PersistenceException {
        if (!this.idToUserObject.containsKey(id)) {
            throw new ObjectNotFoundException();
        }
        return this.idToUserObject.get(id);
    }

    private void mapUserTypeToEmptyListIfNotExists(UserType type) {
        if (!this.userTypeMappingToUserObjects.containsKey(type)) {
            this.userTypeMappingToUserObjects.put(type, new LinkedList());
        }
    }

    private long getAndIncrementNextId() {
        long result = this.nextId++;
        return result;
    }
}

