package de.fhdw.wtf.persistence.meta;

/**
 * A class to represent a user transacton. User transactions are a subset of user Transactions implementing the
 * Transaction interface and thererore could be used to manipulate data. The of an user transaction must have its
 * abstract flag set.
 * 
 */
public class UserTransaction extends UserObject implements Transaction {
	
	/**
	 * Construtor for a new User Transaction. It should only be called from the Objectfacade to guarantee consistency
	 * with the database.
	 * 
	 * @param id
	 *            The Id of the User Transaction.
	 * @param instanceOf
	 *            A Type which has its instance of flag set.
	 */
	public UserTransaction(final long id, final Type instanceOf) {
		super(id, instanceOf);
	}
	
	@Override
	public boolean isTheSameAs(final java.lang.Object other) {
		if (!(other instanceof UserTransaction)) {
			return false;
		}
		
		return super.isTheSameAs(other);
	}
}
