package de.fhdw.wtf.persistence.meta;

/**
 * This class represents a Visitor for all descendants of the {@link de.fhdw.wtf.persistence.meta.Type Type-class}. It
 * provides void operations which can throw an exception.
 * 
 * @param <Exc>
 *            Specifies an exception that can be thrown when performing any method for this classes operations.
 */
public interface TypeVisitorException<Exc extends Exception> {
	
	/**
	 * Handler for a given UserType.
	 * 
	 * @param type
	 *            the UserType.
	 * @throws Exc
	 *             depending on a concrete implementation of this operation.
	 */
	void handleUserType(UserType type) throws Exc;
	
	/**
	 * Handler for a given BaseType.
	 * 
	 * @param t
	 *            the BaseType.
	 * @throws Exc
	 *             depending on a concrete implementation of this operation.
	 */
	void handleBaseType(Type t) throws Exc;
}
